/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls.legacy;

import com.floragunn.searchguard.enterprise.dlsfls.legacy.DlsFlsProcessedConfig;
import com.floragunn.searchguard.enterprise.dlsfls.legacy.DlsQueryParser;
import com.floragunn.searchguard.support.HeaderHelper;
import com.floragunn.searchguard.support.SgUtils;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.threadpool.ThreadPool;

public class DlsFlsSearchOperationListener
implements SearchOperationListener {
    private final ThreadPool threadPool;
    private final DlsQueryParser dlsQueryParser;
    private final AtomicReference<DlsFlsProcessedConfig> config;

    DlsFlsSearchOperationListener(ThreadPool threadPool, DlsQueryParser dlsQueryParser, AtomicReference<DlsFlsProcessedConfig> config) {
        this.threadPool = threadPool;
        this.dlsQueryParser = dlsQueryParser;
        this.config = config;
    }

    public void onPreQueryPhase(SearchContext context) {
        try {
            if (!this.config.get().isEnabled()) {
                return;
            }
            Map queries = (Map)((Object)HeaderHelper.deserializeSafeFromHeader((ThreadContext)this.threadPool.getThreadContext(), (String)"_sg_dls_query"));
            String dlsEval = SgUtils.evalMap((Map)queries, (String)context.indexShard().indexSettings().getIndex().getName());
            if (dlsEval != null) {
                if (context.suggest() != null) {
                    return;
                }
                assert (context.parsedQuery() != null);
                Set unparsedDlsQueries = (Set)queries.get(dlsEval);
                if (unparsedDlsQueries != null && !unparsedDlsQueries.isEmpty()) {
                    BooleanQuery.Builder queryBuilder = this.dlsQueryParser.parse(unparsedDlsQueries, context.getSearchExecutionContext(), q -> new ConstantScoreQuery(q));
                    queryBuilder.add(context.parsedQuery().query(), BooleanClause.Occur.MUST);
                    ParsedQuery dlsQuery = new ParsedQuery((Query)queryBuilder.build());
                    if (dlsQuery != null) {
                        context.parsedQuery(dlsQuery);
                        context.preProcess();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error evaluating dls for a search query: " + e, e);
        }
    }
}

